/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.common.block;

import gloridifice.watersource.common.tile.WaterFilterDownTile;
import gloridifice.watersource.common.tile.WaterFilterUpTile;
import gloridifice.watersource.registry.FluidRegistry;
import gloridifice.watersource.registry.ItemRegistry;
import gloridifice.watersource.registry.TileEntityTypesRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class WaterFilterBlock
extends Block {
    public static final BooleanProperty IS_UP = BooleanProperty.func_177716_a((String)"up");
    private boolean flag = false;

    public WaterFilterBlock(String name, AbstractBlock.Properties properties) {
        super(properties);
        this.setRegistryName(name);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)IS_UP, (Comparable)Boolean.valueOf(false)));
    }

    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{IS_UP});
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(state, world, pos, explosion);
        this.onBlockRemoved(world, pos, state);
    }

    public void onBlockRemoved(World worldIn, BlockPos pos, BlockState state) {
        ItemStack stack;
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof WaterFilterUpTile && !(stack = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(data -> data.getStackInSlot(0)).orElse(ItemStack.field_190927_a)).func_190926_b()) {
            WaterFilterBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
        }
        if (tile instanceof WaterFilterDownTile) {
            stack = ItemStack.field_190927_a;
            if (worldIn.func_175625_s(pos.func_177984_a()) instanceof WaterFilterUpTile) {
                stack = worldIn.func_175625_s(pos.func_177984_a()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(data -> data.getStackInSlot(0)).orElse(ItemStack.field_190927_a);
            }
            if (!stack.func_190926_b()) {
                WaterFilterBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
            }
        }
        if (((Boolean)state.func_177229_b((Property)IS_UP)).booleanValue()) {
            worldIn.func_175656_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P());
        } else {
            worldIn.func_175656_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
        this.onBlockRemoved(worldIn, pos, state);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)state.func_206870_a((Property)IS_UP, (Comparable)Boolean.valueOf(true)), 3);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_195991_k().func_175623_d(context.func_195995_a().func_177984_a()) && context.func_195995_a().func_177984_a().func_177956_o() < 255) {
            return this.func_176223_P();
        }
        return null;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return (Boolean)state.func_177229_b((Property)IS_UP) != false ? TileEntityTypesRegistry.WATER_FILTER_UP_TILE.func_200968_a() : TileEntityTypesRegistry.WATER_FILTER_DOWN_TILE.func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        this.flag = false;
        if (((Boolean)state.func_177229_b((Property)IS_UP)).booleanValue()) {
            WaterFilterUpTile tile = (WaterFilterUpTile)worldIn.func_175625_s(pos);
            tile.getUpTank().ifPresent(fluidTankUp -> tile.getStrainer().ifPresent(strainerHandler -> tile.getProps().ifPresent(propsHandler -> {
                ItemStack strainerStack = strainerHandler.getStackInSlot(0);
                ItemStack propsStack = propsHandler.getStackInSlot(0);
                ItemStack heldItem = player.func_184586_b(handIn);
                if (!heldItem.func_190926_b()) {
                    if (!strainerStack.func_190926_b()) {
                        this.flag = FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (IFluidHandler)fluidTankUp);
                    }
                } else if (player.func_225608_bj_()) {
                    if (fluidTankUp.getFluid().isEmpty()) {
                        if (!strainerStack.func_190926_b()) {
                            if (!player.field_71071_by.func_70441_a(strainerStack)) {
                                player.func_71019_a(strainerStack, false);
                            }
                            strainerHandler.setStackInSlot(0, ItemStack.field_190927_a);
                        } else if (!propsStack.func_190926_b()) {
                            if (!player.field_71071_by.func_70441_a(propsStack)) {
                                player.func_71019_a(propsStack, false);
                            }
                            propsHandler.setStackInSlot(0, ItemStack.field_190927_a);
                        }
                        this.flag = true;
                    } else {
                        fluidTankUp.setFluid(FluidStack.EMPTY);
                        worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187624_K, SoundCategory.BLOCKS, 0.3f, 1.0f, true);
                        this.flag = true;
                    }
                }
                if (!player.func_225608_bj_() && !heldItem.func_190926_b()) {
                    if (ItemTags.func_199903_a().func_199910_a(new ResourceLocation("watersource", "strainers")).func_230235_a_((Object)heldItem.func_77973_b())) {
                        if (strainerStack.func_190926_b()) {
                            strainerHandler.insertItem(0, heldItem.func_77946_l(), true);
                            if (!player.func_184812_l_()) {
                                ItemStack itemStack1 = heldItem.func_77946_l();
                                itemStack1.func_190920_e(heldItem.func_190916_E() - 1);
                                player.func_184611_a(handIn, itemStack1);
                            }
                            this.flag = true;
                        } else {
                            ItemStack heldItem1 = heldItem.func_77946_l();
                            player.func_184611_a(handIn, strainerStack);
                            strainerHandler.setStackInSlot(0, heldItem1);
                            this.flag = true;
                        }
                    }
                    if (heldItem.func_77973_b() == Items.field_205158_fa) {
                        player.func_184611_a(handIn, propsHandler.insertItem(0, heldItem.func_77946_l(), false));
                    }
                }
            })));
        } else {
            WaterFilterDownTile tile = (WaterFilterDownTile)worldIn.func_175625_s(pos);
            tile.getDownTank().ifPresent(fluidTankDown -> {
                ItemStack heldItem = player.func_184586_b(handIn);
                if (!heldItem.func_190926_b()) {
                    FluidStack downFluidStack;
                    player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(playerInventory -> {
                        FluidActionResult fluidActionResult = FluidUtil.tryFillContainerAndStow((ItemStack)heldItem, (IFluidHandler)fluidTankDown, (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true);
                        if (fluidActionResult.isSuccess()) {
                            player.func_184611_a(handIn, fluidActionResult.getResult());
                            this.flag = true;
                        }
                    });
                    if (!(heldItem.func_77973_b() != Items.field_151069_bo || (downFluidStack = fluidTankDown.getFluid()).isEmpty() || downFluidStack.getFluid() != FluidRegistry.PURIFIED_WATER.get() && downFluidStack.getFluid() != FluidRegistry.SOUL_WATER.get())) {
                        ItemStack itemStack = ItemStack.field_190927_a;
                        if (downFluidStack.getFluid() == FluidRegistry.PURIFIED_WATER.get()) {
                            itemStack = new ItemStack((IItemProvider)ItemRegistry.PURIFIED_WATER_BOTTLE);
                        } else if (downFluidStack.getFluid() == FluidRegistry.SOUL_WATER.get()) {
                            itemStack = new ItemStack((IItemProvider)ItemRegistry.SOUL_WATER_BOTTLE);
                        }
                        if (!itemStack.func_190926_b() && downFluidStack.getAmount() >= 250) {
                            this.flag = player.field_71071_by.func_70441_a(itemStack);
                            if (!this.flag) {
                                player.func_71019_a(itemStack, false);
                            }
                            fluidTankDown.drain(250, IFluidHandler.FluidAction.EXECUTE);
                            if (!player.func_184812_l_()) {
                                heldItem.func_190920_e(heldItem.func_190916_E() - 1);
                            }
                            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187624_K, SoundCategory.PLAYERS, 0.8f, 1.0f, true);
                        }
                    }
                } else if (player.func_225608_bj_() && !fluidTankDown.getFluid().isEmpty()) {
                    fluidTankDown.setFluid(FluidStack.EMPTY);
                    worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187630_M, SoundCategory.PLAYERS, 0.6f, 1.0f, true);
                    this.flag = true;
                }
            });
        }
        return ActionResultType.SUCCESS;
    }
}

